/*******************************************************
Filename		:  di_project_table.sql
Release 		:  c2.0
SIR			:  1471
Description		:  create and populate di_project dimension table.
Author			:  Joseph Wilson
Date			:  1/9/2003
Comments		:  modified to rename columns -Ganesh.
			   06/13/03 updated v2.0
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
**********************************************************/

SPOOL di_project_table.log

drop sequence seq_di_project;

create sequence seq_di_project
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_project;

create table di_project 
tablespace storetdata
storage (initial 5M next 5M)
nologging
as select seq_di_project.nextval pk_isn,
TSMPROJ_IS_NUMBER      ,
TSMPROJ_ORG_ID         ,
IDENTIFICATION_CD project_cd,     
NAME   project_name,                
START_DATE          ,   
PLANNED_DURATION    
from storet1.tsmproj;

commit;

alter table di_project
modify pk_isn number not null;

alter table di_project
add constraint pk_project primary key (pk_isn)
using index
tablespace storetindx
storage (initial 3M next 3M);     


alter table di_project add fk_org number(12);

create index dp_project_proj_org_id  on di_project(tsmproj_org_id)
tablespace storetindx
storage (initial 3M next 3M)
nologging;

update di_project proj set fk_org = (
	select org.pk_isn from di_org org where proj.tsmproj_org_id = org.organization_id);

commit;

drop index dp_project_proj_org_id;

create index ipr_isn_orgid on di_project(tsmproj_is_number,tsmproj_org_id)
tablespace storetindx
storage ( initial 3M next 3M)
nologging;

SPOOL OFF